#ifndef MOVELIST_H
#define MOVELIST_H

#include "defs.h"
#include "piece.h"
#include "squares.h"


struct sHistab {
    uint max;
    uint value[numpieces][BRDSQ]; //piece type and tosq
};

struct sKillers {
    uint k1[maxply];
    uint k2[maxply];
    uint mk[maxply];
};

struct sScoreOpt {
    bool histab;
    bool mvvlva;
    bool killer;
    bool hashmove;
    bool matekiller;
};

struct sOrderstats {
    uint killer1;
    uint killer2;
    uint histab;
    uint matekiller;
    uint capture;
    uint badcapture;
    uint hashmove;
    uint qprom;
    uint qpromcap;
    uint minorprom;
    uint epcapture;
    uint castle;
};

class cBoard;
class cMaterial;

class cMovelist {

private:

        uint movelist[maxply][maxmoves];
        uint movecount[maxply];
        int movescores[maxply][maxmoves];
        sHistab histab;
        sKillers killers;
        uint pvmove;
        sOrderstats stats;

        const int *tab;


        cMovelist( const cMovelist & );
        cMovelist &operator = ( const cMovelist & cMovelist);

        void ordermove(uint move, uint &cap, const uint &flag, const uint &prom, uint &ply, uint pce, cBoard &pboard, int *score, cMaterial &material);
        int ordercapture(uint move, cBoard &pboard, cMaterial &material);

public:

        cMovelist();

        sScoreOpt opt[1];
        void init_opt();

       uint *p2list(uint &ply) {return movelist[ply];}
       int *p2scores(uint &ply) {return movescores[ply];}
       uint &getcount(uint &ply) { return movecount[ply]; }//shows for current ply
       uint &getpvmove() { return pvmove; }
       void setpvmove (uint pvm) { pvmove = pvm; }

       void printmovelist(uint &ply);//prints movelist for the current ply
       void printatplymovelist(uint ply);//prints movelist for the given ply
       void resetcount(uint &ply) { movecount[ply]=0;}
       void incrmovecount(uint &ply) { this->movecount[ply]++; }
       void addmove(uint &from, uint &to, uint &cap, const uint &flag, const uint &prom, uint &ply, uint pce, cBoard &pboard, cMaterial &material);
       void addpawnmove(uint &from, uint &to, uint &cap, uint side, uint &ply, uint pce, cBoard &pboard, cMaterial &material);
       void scoremove(uint move, uint depth, uint pce);
       void failowmove(uint move, uint depth, uint pce);
       void score_killer(uint move, int score, uint ply);
       void resethistab();
       void resetkillers();
       void resetstats();

       void says_stats();

};


#endif

